package gov.va.med.mhv.integration.phr.stage.transfer;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

/**
 * StageReminder entity.
 * 
 */

public class StageProblemList extends StageEntity {

	// Fields
	
	private String problem;
	private String provider;
	private String status;
	private String acuity;
	private String comments;
	private Date eventTime;
	private String eventTimeImprecise;
	
	// Constructors

	/**
	 * default constructor do not provide auto initialization since this class
	 * can be used in findByExample
	 */
	public StageProblemList() {
		super();
	}

	// Property accessors

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = doubleUnescapeHtml(comments);
	}

	public Date getEventTime(){
    return eventTime;
	}
	
	public void setEventTime(Date eventTime) {
		this.eventTime = eventTime;
	}
   
	public String getEventTimeImprecise() {
		return eventTimeImprecise;
	}

	public void setEventTimeImprecise(String eventTimeImprecise) {
		this.eventTimeImprecise = eventTimeImprecise;
	}

	public String getProblem() {
		return problem;
	}

	public void setProblem(String problem) {
		this.problem = doubleUnescapeHtml(problem);
	}

	public String getProvider() {
		return provider;
	}

	public void setProvider(String provider) {
		this.provider = doubleUnescapeHtml(provider);
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = doubleUnescapeHtml(status);
	}
	
	public String getAcuity() {
		return acuity;
	}

	public void setAcuity(String acuity) {
		this.acuity = doubleUnescapeHtml(acuity);
	}

		
	public String toString() {
		return  "StageProblemList {" + 
				", id=" + getId() + 
				", oplock=" + oplock +
				", createdDate=" + createdDate + 
				", modifiedDate=" + modifiedDate + 
				", icn='" + icn + '\'' +
				", stationNumber='"	+ stationNumber + '\'' + 
				", requestMsgCtrlId=" + requestMsgCtrlId + 
				", responseMsgCtrlId=" + responseMsgCtrlId + 
				", extractStatus='" + extractStatus + '\'' + 
				", recordStatus='" + recordStatus + '\'' + 
				", Comments='" + comments + '\'' +
				", Problem='" + problem + '\'' +
				", Provider='" + provider + '\'' +
				", Status='" + status + '\'' +
				", Acuity='" + acuity + '\'' +
				", eventTime='" + eventTime + '\'' +
				", eventTimeImprecise='" + eventTimeImprecise + '\'' +
				'}';
	}

	@Override
	public boolean equals(Object obj) {
		boolean result = false;
		result = String.valueOf(obj).equalsIgnoreCase(String.valueOf(this));
		return result;
	}

	public void setAK(StageEntityAK ak) {
		this.icn = ak.getIcn();
		// Station number is excluded because it comes from the response not the
		// request
		// in the case of immunization.

		// this.stationNumber=ak.getStationNumber();
		this.requestMsgCtrlId = ak.getRequestMsgCtrlId();
		this.responseMsgCtrlId = ak.getResponseMsgCtrlId();
	}

	public String toCompare() {
		return ""+
				getAcuity()+
				StringUtils.deleteWhitespace(getComments())+
				getEventTime()+
				getProblem()+
				getProvider()+
				getStatus();
		
	}
}
